<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments;

use Closure;
use Illuminate\Support\Collection;

class DetermineAndProcessResults
{
    /**
     * @param  Collection<array-key,mixed>  $payload
     * @param  Closure(): void  $next
     * @return void
     */
    public function handle(Collection $payload, Closure $next)
    {
        if (! $payload->has('assessment')) {
            throw new \Exception('Assessment not found');
        }

        $assessment = $payload->get('assessment');

        $assessmentResults = collect();

        if (! $payload->has('scoresPerCategory')) {
            throw new \Exception('Scores per category not found in payload, please try again.');
        }

        foreach ($payload->get('scoresPerCategory') as $categoryId => $totalScore) {

            $interpretationClass = config('questionnaire.models.interpretation');

            $scoreForLookup = (int) round($totalScore);

            $interpretation = $interpretationClass::query()
                ->where('category_id', $categoryId)
                ->where('min_score', '<=', $scoreForLookup)
                ->where('max_score', '>=', $scoreForLookup)
                ->first();

            if (! $interpretation) {
                throw new \Exception(
                    "No interpretation found for category $categoryId with score $totalScore (rounded to $scoreForLookup for lookup)",
                );
            }

            $result = $assessment->results()->create([
                'category_id' => $categoryId,
                'scale_id' => $interpretation->scale_id,
                'total_score' => $totalScore,
            ]);

            $assessmentResults->push($result);
        }

        $payload->put('assessmentResults', $assessmentResults);

        return $next($payload);
    }
}
