<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments;

use Closure;
use Concept7\LaravelQuestionnaire\Support\ScoreCalculatorFactory;
use Illuminate\Support\Collection;

class CalculateScores
{
    /**
     * @param  Collection<array-key,mixed>  $payload
     * @param  Closure(): void  $next
     * @return mixed
     */
    public function handle(Collection $payload, Closure $next)
    {
        $questionnaire = $payload->get('questionnaire');

        $submittedAnswersPayload = $payload->get('submittedAnswers');

        $answerClass = config('questionnaire.models.answer');

        $realAnswers = $answerClass::query()
            ->whereIn('id', $submittedAnswersPayload->pluck('answer_id'))
            ->with('question.category')
            ->get();

        $strategy = ScoreCalculatorFactory::make($questionnaire->calculation_type);

        $scoresPerCategory = $realAnswers
            ->groupBy(function ($answer) {
                return $answer->question->category_id;
            })->map(function (Collection $answersInCategory) use ($strategy) {
                return $strategy->calculate($answersInCategory);
            });

        $payload->put('scoresPerCategory', $scoresPerCategory);

        return $next($payload);
    }
}
