@extends(config('questionnaire.layout', 'layouts.app'))


@section('content')
    <div>
        <canvas id="chart" style="max-height: 420px;"></canvas>
    </div>
@endsection

@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const chartData = @json($chartData);
            if (!chartData) return;

            const chartOptions = @json($chartOptions ?? null);

            const el = document.getElementById('chart');
            if (!el) return;
            const ctx = el.getContext('2d');

            new Chart(ctx, {
                type: 'bar',
                data: chartData,
                options: chartOptions ?? { responsive: true }
            });
        });

    </script>
@endpush

