# Laravel Questionnaire

[![Latest Version on Packagist](https://img.shields.io/packagist/v/concept7/laravel-questionnaire.svg?style=flat-square)](https://packagist.org/packages/concept7/laravel-questionnaire)
[![Total Downloads](https://img.shields.io/packagist/dt/concept7/laravel-questionnaire.svg?style=flat-square)](https://packagist.org/packages/concept7/laravel-questionnaire)

A package that enables running questionnaires in Laravel.

## Installation

You can install the package via composer:

```bash
composer require concept7/laravel-questionnaire
```

You can publish and run the migrations with:

```bash
php artisan vendor:publish --tag="questionnaire-migrations"
php artisan migrate
```

You can publish the config file with:

```bash
php artisan vendor:publish --tag="questionnaire-config"
```

This is the contents of the published config file:

```php
return [
    // modes: default,alpine_via_api(wizard),alpine(wizard non-api)
    'mode' => 'default',
    'layout' => 'laravel-questionnaire::layouts.app',
    'with_progress_bar' => true,

    'participant_route_key' => 'id',

    'middleware' => [
        'assessments.create' => ['web'],
        'assessments.show' => ['auth'],
    ],

    'models' => [
        'questionnaire' => \Concept7\LaravelQuestionnaire\Models\Questionnaire::class,
        'question' => \Concept7\LaravelQuestionnaire\Models\Question::class,
        'answer' => \Concept7\LaravelQuestionnaire\Models\Answer::class,
        'interpretation' => \Concept7\LaravelQuestionnaire\Models\Interpretation::class,
        'scale' => \Concept7\LaravelQuestionnaire\Models\Scale::class,
        'category' => \Concept7\LaravelQuestionnaire\Models\Category::class,
        'assessment' => \Concept7\LaravelQuestionnaire\Models\Assessment::class,
        'assessment_result' => \Concept7\LaravelQuestionnaire\Models\AssessmentResult::class,
        'assessment_answer' => \Concept7\LaravelQuestionnaire\Models\AssessmentAnswer::class,
        'participant' => \Concept7\LaravelQuestionnaire\Models\User::class,
        'notifications' => [
            'invitation' => \Concept7\LaravelQuestionnaire\Notifications\QuestionnaireInvitation::class,
        ],
    ],

    'thank_you_page_enabled' => true,
    'allow_public_access' => true,
];
```

## Usage

### Routes

The package registers the following routes:

-   **Create Assessment**: `/questionnaire/{questionnaire:slug}/assessments/create/{participant?}` (`questionnaire.assessments.create`)
-   **Store Assessment**: `/questionnaire/{questionnaire:slug}/assessments/{participant?}` (POST) (`questionnaire.assessments.store`)
-   **Show Assessment**: `/questionnaire/{questionnaire:slug}/assessments/{assessment}` (`questionnaire.assessments.show`)
-   **Thank You**: `/questionnaire/{questionnaire:slug}/thank-you` (`questionnaire.thankyou`)

### Test Data

You can generate test data to quickly populate your database for development:

```bash
php artisan questionnaire:generate-test-data-command
```

This command will allow you to choose from various data presets like '4DKL', 'Concept7DigitalMaturityScan', etc.

## Testing

```bash
vendor/bin/pest
```

## Changelog

Please see [CHANGELOG](CHANGELOG.md) for more information on what has changed recently.

## Contributing

Please see [CONTRIBUTING](CONTRIBUTING.md) for details.

## Security Vulnerabilities

Please review [our security policy](../../security/policy) on how to report security vulnerabilities.

## Credits

-   [Concept7](https://github.com/concept7)
-   [All Contributors](../../contributors)

## License

The MIT License (MIT). Please see [License File](LICENSE.md) for more information.
