<?php

namespace Concept7\LaravelQuestionnaire\Enums;

enum InputTypeEnum: string
{
    case CHECKBOX = 'checkbox';
    case RADIO = 'radio';
    case SELECT = 'select';
    case SLIDER = 'slider';

    /**
     * This provides the human-readable labels.
     * Filament will automatically use this.
     */
    public function getLabel(): string
    {
        return match ($this) {
            self::CHECKBOX => 'Checkbox',
            self::RADIO => 'Radio',
            self::SELECT => 'Select',
            self::SLIDER => 'Slider',
        };
    }
}
