<?php

namespace Concept7\LaravelQuestionnaire\Database\Factories;

use Concept7\LaravelQuestionnaire\Models\Assessment;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<Assessment>
 */
class AssessmentFactory extends Factory
{
    public function modelName()
    {
        return config('questionnaire.models.assessment');
    }

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $questionnaireClass = config('questionnaire.models.questionnaire');

        return [
            'questionnaire_id' => $questionnaireClass::factory(),
            'assessmentable_id' => null,
            'assessmentable_type' => null,
        ];
    }
}
