<?php

namespace Concept7\LaravelQuestionnaire\Strategies;

use Concept7\LaravelQuestionnaire\Contracts\ScoreCalculationStrategy;
use Illuminate\Support\Collection;

class WeightedAverageStrategy implements ScoreCalculationStrategy
{
    public function calculate(Collection $answers): float|int
    {
        $totalAchievedPoints = 0;
        $totalPossiblePoints = 0;

        foreach ($answers as $answer) {
            $question = $answer->question;

            if (! $question) {
                continue;
            }

            // This is the line the host wants to change
            $weight = $this->getWeight($question);

            $totalAchievedPoints += $answer->score * $weight;

            $maxScore = $question->answers->max('score') ?? 10;
            $totalPossiblePoints += $maxScore * $weight;
        }

        if ($totalPossiblePoints === 0) {
            return 0;
        }

        return round(($totalAchievedPoints / $totalPossiblePoints) * 100, 2);
    }

    protected function getWeight($question): int|float
    {
        return $question->weight ?? 1;
    }
}
