<?php

use Concept7\LaravelQuestionnaire\Actions\Assessments\CalculateScores;
use Concept7\LaravelQuestionnaire\Actions\Assessments\CreateAssessment;
use Concept7\LaravelQuestionnaire\Actions\Assessments\DetermineAndProcessResults;
use Concept7\LaravelQuestionnaire\Actions\Assessments\GetParticipant;
use Concept7\LaravelQuestionnaire\Actions\Assessments\ProcessSubmittedAnswers;

return [
    /**
     * The rendering mode of the questionnaire.
     * Supported: "default", "alpine_via_api" (wizard), "alpine" (wizard non-api)
     */
    'mode' => 'default',

    /**
     * The base layout to be used for the questionnaire views.
     */
    'layout' => 'laravel-questionnaire::layouts.app',

    /**
     * Whether to display the progress bar in the questionnaire.
     */
    'with_progress_bar' => true,

    /**
     * The key used to identify the participant in routes.
     */
    'participant_route_key' => 'id',

    /**
     * Middleware applied to specific routes.
     */
    'middleware' => [
        'assessments.create' => ['web'],
        'assessments.show' => ['auth'],
    ],

    /**
     * The models used for the questionnaire entities.
     * You can override these with your own custom models.
     */
    'models' => [
        'questionnaire' => \Concept7\LaravelQuestionnaire\Models\Questionnaire::class,
        'question' => \Concept7\LaravelQuestionnaire\Models\Question::class,
        'answer' => \Concept7\LaravelQuestionnaire\Models\Answer::class,
        'interpretation' => \Concept7\LaravelQuestionnaire\Models\Interpretation::class,
        'scale' => \Concept7\LaravelQuestionnaire\Models\Scale::class,
        'category' => \Concept7\LaravelQuestionnaire\Models\Category::class,
        'assessment' => \Concept7\LaravelQuestionnaire\Models\Assessment::class,
        'assessment_result' => \Concept7\LaravelQuestionnaire\Models\AssessmentResult::class,
        'assessment_answer' => \Concept7\LaravelQuestionnaire\Models\AssessmentAnswer::class,
        'participant' => \Concept7\LaravelQuestionnaire\Models\User::class,
        'notifications' => [
            'invitation' => \Concept7\LaravelQuestionnaire\Notifications\QuestionnaireInvitation::class,
        ],
    ],

    'actions' => [
        GetParticipant::class,
        CreateAssessment::class,
        ProcessSubmittedAnswers::class,
        CalculateScores::class,
        DetermineAndProcessResults::class,
    ],

    /**
     * Whether the thank you page should be enabled after completion.
     */
    'thank_you_page_enabled' => true,

    /**
     * Whether public access without authentication is allowed.
     */
    'allow_public_access' => true,
];
