<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class Assessment extends Model
{
    /** @use HasFactory<\Concept7\LaravelQuestionnaire\Database\Factories\AssessmentFactory> */
    use HasFactory;

    protected $fillable = [
        'questionnaire_id',
        'completed_at',

        'assessmentable_id',
        'assessmentable_type',
    ];

    /**
     * @return BelongsTo<Model,Assessment>
     */
    public function assessmentable(): MorphTo
    {
        return $this->morphTo();
    }

    /**
     * @return BelongsTo<Model,Assessment>
     */
    public function questionnaire(): BelongsTo
    {
        $questionnaireModel = config('questionnaire.models.questionnaire');

        return $this->belongsTo($questionnaireModel);
    }

    /**
     * @return HasMany<Model,Assessment>
     */
    public function answers(): HasMany
    {
        $answerModel = config('questionnaire.models.assessment_answer');

        return $this->hasMany($answerModel);
    }

    /**
     * @return HasMany<Model,Assessment>
     */
    public function results(): HasMany
    {
        $resultModel = config('questionnaire.models.assessment_result');

        return $this->hasMany($resultModel);
    }
}
