<?php

use Concept7\LaravelQuestionnaire\Models\Category;
use Concept7\LaravelQuestionnaire\Models\Question;
use Concept7\LaravelQuestionnaire\Models\Questionnaire;
use Concept7\LaravelQuestionnaire\Models\User;

beforeEach(function () {
    config()->set('questionnaire.models.user', User::class);

    $this->user = User::factory()->create();
    $this->actingAs($this->user);

    $categories = Category::factory()
        ->count(5)
        ->create()
        ->pluck('id');

    $this->questionnaire = Questionnaire::factory()->create();

    Question::factory()
        ->count(5)
        ->for($this->questionnaire)
        ->state(function (array $attributes) use ($categories) {
            return [
                'category_id' => $categories->random(),
            ];
        })
        ->hasAnswers(5)
        ->create();
});

describe('create assessment', function () {
    test('route is accessible', function () {
        $this->get(route('questionnaire.assessments.create', ['questionnaire' => $this->questionnaire->slug]))
            ->assertStatus(200);
    });

    test('guests can view the list of questions', function () {
        $this->get(route('questionnaire.assessments.create', ['questionnaire' => $this->questionnaire->slug]))
            ->assertStatus(200)
            ->assertViewIs('laravel-questionnaire::assessments.create')
            ->assertSee(Question::first()->text);
    });
});
