<?php

namespace Concept7\LaravelQuestionnaire\Http\Middleware;

use Closure;

class EnsureAssessmentAccess
{
    public function handle($request, Closure $next)
    {
        // 1. Get the questionnaire from the route
        // (Assumes your route parameter is named {questionnaire})
        $questionnaire = $request->route('questionnaire');
        // If using model binding, get the ID. If strictly ID, use as is.
        $qId = $questionnaire instanceof \Illuminate\Database\Eloquent\Model
            ? $questionnaire->getKey()
            : $questionnaire;

        // 2. Define the Session Key (Must match what you set in InvitationController)
        $sessionKey = "allowed_assessment_{$qId}";
        $respondentId = null;

        if (! auth()->check() && ! session()->has($sessionKey)) {
            abort(403, 'Please login or request an invitation.');
        }

        if (auth()->check()) {
            $respondentId = auth()->id();
        } elseif (session()->has($sessionKey)) {
            $respondentId = session()->get($sessionKey);
        }

        $request->merge(['respondent_id' => $respondentId]);

        return $next($request);
    }
}
