<?php

namespace Concept7\LaravelQuestionnaire\Http\Controllers\Questionnaire;

use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class InvitationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function open(
        Request $request,
        $questionnaire,
        $user,
    ): RedirectResponse {

        $key = "allowed_assessment_{$questionnaire->getKey()}";
        session()->put($key, $user->getKey());

        $userProvider = config('auth.guards.web.provider');
        $userClass = config("auth.providers.{$userProvider}.model");

        if (! $user->exists) {
            abort(404);
        }

        return redirect()
            ->route('questionnaire.assessments.create', [
                'questionnaire' => $questionnaire,
            ])
            ->with(['invited_user_key' => $user->getkey()]);
    }
}
