<?php

namespace Concept7\LaravelQuestionnaire\Enums;

enum CalculationTypeEnum: string
{
    case SUM = 'sum';
    case AVERAGE = 'average';
    case HIGHEST_SCORE = 'highest_score';
    case WEIGHTED_AVERAGE = 'weighted_average';

    /**
     * This provides the human-readable labels.
     * Filament will automatically use this.
     */
    public function getLabel(): string
    {
        return match ($this) {
            self::SUM => 'Sum',
            self::AVERAGE => 'Average',
            self::HIGHEST_SCORE => 'Highest Score',
            self::WEIGHTED_AVERAGE => 'Weighted Average',
        };
    }
}
