<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments\Invitations;

use Concept7\LaravelQuestionnaire\Notifications\QuestionnaireInvitation;
use Illuminate\Support\Facades\URL;

class SendQuestionnaireInvitation
{
    public function execute($user, $questionnaire, int $expire = 24)
    {
        $url = URL::temporarySignedRoute(
            'questionnaire.invite',
            now()->addHours($expire),
            ['questionnaire' => $questionnaire->slug, 'user' => $user->getKey()]
        );

        $notificationClass = config(
            'questionnaire.notifications.invitation',
            QuestionnaireInvitation::class
        );

        $user->notify(new $notificationClass($questionnaire, $url));
    }
}
