<?php

use Concept7\LaravelQuestionnaire\Http\Controllers\Questionnaire\AssessmentController;
use Concept7\LaravelQuestionnaire\Http\Controllers\Questionnaire\InvitationController;
use Illuminate\Support\Facades\Route;

Route::middleware(['web'])->group(function () {
    Route::get('/questionnaire/{questionnaire:slug}/thank-you', [AssessmentController::class, 'thankYou'])
        ->name('questionnaire.thankyou');

    Route::get('/questionnaire/invite/{questionnaire:slug}/{user}', [InvitationController::class, 'open'])
        ->name('questionnaire.invite')
        ->middleware('signed');

    Route::middleware(['questionnaire.access'])->group(function () {
        Route::resource('questionnaire.assessments', AssessmentController::class)
            ->scoped(['questionnaire' => 'slug'])
            ->except('show');
    });

    Route::middleware(['auth'])->group(function () {
        Route::get('/questionnaire/{questionnaire:slug}/assessments/{assessment}', [
            AssessmentController::class,
            'show',
        ])->name('questionnaire.assessments.show');
    });
});
