@extends(config('questionnaire.layout', 'layouts.app'))

@section('content')
<form
    method="POST"
    action="{{ route('questionnaire.assessments.store', ['questionnaire' => $questionnaire->slug ]) }}"
>
    @csrf

    @foreach($questions as $index => $question)
        @php
            $fieldName = 'questions_'.$question->getKey();
            $defaultOld = $question->type === 'checkbox' ? [] : null;
            $oldValue = old($fieldName, $defaultOld);
        @endphp

        <fieldset>
            <legend class="text-sm font-medium">
                {!! $loop->iteration .' - ' . $question->text !!}
            </legend>
            <div class="answers mt-2 gap-y-2">
                <x-dynamic-component
                    :component="'laravel-questionnaire::inputs.' . $question->type->value"
                    :question="$question"
                    :field-name="$fieldName"
                    :old-value="$oldValue"
                />
            </div>
            @error($fieldName)
                <div class="alert alert-danger" style="color: red;">
                    {{ $message }}
                </div>
            @enderror
        </fieldset>
    @endforeach

    <button
        type="submit"
        class="p-2 bg-blue-500 text-white rounded"
    >
        {{ __('Submit') }}
    </button>
</form>
@endsection
