<?php

use Concept7\LaravelQuestionnaire\Http\Controllers\Questionnaire\AssessmentController;
use Illuminate\Support\Facades\Route;

Route::middleware(['web'])->group(function () {
    Route::get('/questionnaire/{questionnaire:slug}/thank-you', [AssessmentController::class, 'thankYou'])->name('questionnaire.thankyou');

    Route::middleware(config('questionnaire.middleware.assessments.store', []))->group(function () {
        Route::post('questionnaire/{questionnaire:slug}/assessments/{participant?}', [AssessmentController::class, 'store'])->name('questionnaire.assessments.store');
    });

    Route::middleware(config('questionnaire.middleware.assessments.create', []))->group(function () {
        Route::get('questionnaire/{questionnaire:slug}/assessments/create/{participant?}', [AssessmentController::class, 'create'])->name('questionnaire.assessments.create');
    });

    Route::middleware(config('questionnaire.middleware.assessment.show', []))->group(function () {
        Route::get('/questionnaire/{questionnaire:slug}/assessments/{assessment}', [
            AssessmentController::class,
            'show',
        ])->name('questionnaire.assessments.show');
    });
});
