<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments\Seeders;

use Concept7\LaravelQuestionnaire\Enums\CalculationTypeEnum;
use Concept7\LaravelQuestionnaire\Models\Answer;
use Concept7\LaravelQuestionnaire\Models\Category;
use Concept7\LaravelQuestionnaire\Models\Interpretation;
use Concept7\LaravelQuestionnaire\Models\Question;
use Concept7\LaravelQuestionnaire\Models\Questionnaire;
use Concept7\LaravelQuestionnaire\Models\Scale;
use Illuminate\Support\Facades\File;

class DasScanSeederAction
{
    public function run($name): void
    {
        $jsonPath = __DIR__.'/../../../database/seeders/data/das-scan.json';
        $questionnaireData = json_decode(File::get($jsonPath), true);

        $questionnaire = Questionnaire::create([
            'title' => $name,
            'slug' => str($name)->slug(),
            'type' => CalculationTypeEnum::SUM,
        ]);

        $answerTemplate = [
            ['text' => 'Eens', 'score' => 1, 'order' => 1],
            ['text' => 'Oneens', 'score' => 0, 'order' => 2],
        ];

        $categoriesCache = [];
        $categoryNames = collect($questionnaireData)
            ->pluck('behavioural_type.0')
            ->unique()
            ->filter();

        foreach ($categoryNames as $categoryName) {
            $categoriesCache[$categoryName] = Category::firstOrCreate(
                ['name' => str($categoryName)->ucfirst()],
                [
                    'description' => "Vragen gerelateerd aan het '{$categoryName}' gedragstype.",
                ],
            );
        }

        $scales = [
            'laag' => Scale::firstOrCreate([
                'name' => 'Laag',
                'description' => 'Lage score',
            ]),
            'gemiddeld' => Scale::firstOrCreate([
                'name' => 'Gemiddeld',
                'description' => 'Gemiddelde score',
            ]),
            'hoog' => Scale::firstOrCreate([
                'name' => 'Hoog',
                'description' => 'Hoge score',
            ]),
        ];

        $interpretationRanges = [
            'dominant' => [
                'laag' => ['min' => 0, 'max' => 10],
                'gemiddeld' => ['min' => 11, 'max' => 20],
                'hoog' => ['min' => 21, 'max' => 30],
            ],
            'afstandelijk' => [
                'laag' => ['min' => 0, 'max' => 7],
                'gemiddeld' => ['min' => 8, 'max' => 15],
                'hoog' => ['min' => 16, 'max' => 23],
            ],
            'sociaal' => [
                'laag' => ['min' => 0, 'max' => 6],
                'gemiddeld' => ['min' => 7, 'max' => 13],
                'hoog' => ['min' => 14, 'max' => 20],
            ],
        ];

        foreach ($interpretationRanges as $categoryName => $ranges) {
            if (! isset($categoriesCache[$categoryName])) {
                continue;
            }
            $categoryId = $categoriesCache[$categoryName]->getKey();

            foreach ($ranges as $scaleKey => $range) {
                Interpretation::create([
                    'category_id' => $categoryId,
                    'scale_id' => $scales[$scaleKey]->getKey(),
                    'min_score' => $range['min'],
                    'max_score' => $range['max'],
                ]);
            }
        }

        foreach ($questionnaireData as $index => $data) {
            $categoryName = $data['behavioural_type'][0] ?? null;

            if (! $categoryName || ! isset($categoriesCache[$categoryName])) {
                continue;
            }
            $category = $categoriesCache[$categoryName];

            $question = Question::create([
                'questionnaire_id' => $questionnaire->getKey(),
                'text' => $data['title'],
                'category_id' => $category->getKey(),
                'order' => $index + 1,
            ]);

            foreach ($answerTemplate as $answer) {
                Answer::create([
                    'question_id' => $question->getKey(),
                    'text' => $answer['text'],
                    'score' => $answer['score'],
                    'order' => $answer['order'],
                ]);
            }
        }
    }
}
