<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments;

use Closure;
use Illuminate\Support\Collection;

class CreateAssessment
{
    /**
     * @param  Collection<array-key,mixed>  $payload
     * @param  Closure(): void  $next
     * @return void
     */
    public function handle(Collection $payload, Closure $next)
    {
        $questionnaire = $payload->get('questionnaire');

        if (! $questionnaire) {
            throw new \Exception('Questionnaire not found');
        }

        $attributes = [
            'questionnaire_id' => $questionnaire->getKey(),
            'completed_at' => now(),
        ];

        if ($participant = $payload->get('participant')) {
            $assessment = $participant->assessments()->create($attributes);
        } else {
            $assessmentClass = config('questionnaire.models.assessment');
            $assessment = $assessmentClass::create($attributes);
        }

        $payload->put('assessment', $assessment);

        return $next($payload);
    }
}
