@props(['question', 'fieldName', 'oldValue'])

@php
    $sortedAnswers = $question->answers->sortBy('order')->values();
    $answerCount = $sortedAnswers->count();
    $min = 0;
    $max = $answerCount > 0 ? $answerCount - 1 : 0;
    $step = 1;

    $answerIdMap = $sortedAnswers->pluck('id');
    $answerLabelMap = $sortedAnswers->pluck('text');

    $labelMin = $question->slider_label_min;
    $labelMax = $question->slider_label_max;

    $defaultSliderPos = 0;
    $defaultAnswerId = $sortedAnswers->get(0)?->id ?? 'null';
    $defaultLabel = $sortedAnswers->get(0)?->text ?? '';

    if ($oldValue) {
        $pos = $sortedAnswers->search(fn($a) => $a->id == $oldValue);
        if ($pos !== false) {
            $defaultSliderPos = $pos;
            $defaultAnswerId = $oldValue;
            $defaultLabel = $sortedAnswers->get($pos)?->text ?? '';
        }
    } else {
        $defaultSliderPos = (int) floor($max / 2);
        $defaultAnswerId = $sortedAnswers->get($defaultSliderPos)?->id ?? 'null';
        $defaultLabel = $sortedAnswers->get($defaultSliderPos)?->text ?? '';
    }

    $hiddenInputId = 'slider_answer_id_' . $question->id;
    $visualSliderId = 'slider_visual_' . $question->id;
    $labelOutputId = 'slider_label_' . $question->id;
@endphp

<div>
    <input
        type="hidden"
        name="{{ $fieldName }}"
        id="{{ $hiddenInputId }}"
        value="{{ $defaultAnswerId }}"
    >

    <div class="flex items-center space-x-4">
        <input
            type="range"
            id="{{ $visualSliderId }}"
            min="{{ $min }}"
            max="{{ $max }}"
            step="{{ $step }}"
            value="{{ $defaultSliderPos }}"
            class="w-full"
            @if($answerCount === 0) disabled @endif
        >

        <span
            id="{{ $labelOutputId }}"
            class="font-bold w-12 text-right"
        >
            {{ $defaultLabel }}
        </span>
    </div>

    <div
        class="mt-1"
        style="display: grid; grid-template-columns: repeat({{ $answerCount }}, 1fr);"
    >
        @foreach($sortedAnswers as $answer)
            @php
                $textAlign = $loop->first ? 'left' : ($loop->last ? 'right' : 'center');
            @endphp

            <span
                class="text-sm text-gray-600"
                style="text-align: {{ $textAlign }};"
            >
                {{ $answer->text }}
            </span>
        @endforeach
    </div>
</div>

<script>
    (function() {
        const visualSlider = document.getElementById('{{ $visualSliderId }}');
        const hiddenInput = document.getElementById('{{ $hiddenInputId }}');
        const labelOutput = document.getElementById('{{ $labelOutputId }}');

        // Get the data maps from PHP
        const idMap = @json($answerIdMap);
        const labelMap = @json($answerLabelMap);

        visualSlider.addEventListener('input', function() {
            const position = visualSlider.value;

            hiddenInput.value = idMap[position];
            labelOutput.textContent = labelMap[position];
        });
    })();
</script>
