<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments;

use Closure;
use Illuminate\Support\Collection;
use InvalidArgumentException;

class ProcessSubmittedAnswers
{
    /**
     * @param  Collection<array-key,mixed>  $payload
     * @param  Closure(): void  $next
     * @return mixed
     */
    public function handle(Collection $payload, Closure $next)
    {
        $questionnaire = $payload->get('questionnaire');
        $assessment = $payload->get('assessment');
        $validatedData = $payload->get('validatedRequest');

        if (empty($validatedData)) {
            throw new \Exception('No assessment answers found');
        }

        if (! $assessment || ! $questionnaire) {
            throw new InvalidArgumentException(
                'ProcessSubmittedAnswers action requires the "assessment" key and the "questionnaire" key.'
            );
        }

        foreach ($validatedData as $key => $id) {

            $questionId = str($key)->replace('questions_', '')->toString();

            if (empty($questionId)) {
                continue;
            }

            if (is_array($id)) {
                foreach ($id as $answerId) {
                    $assessment->answers()->create([
                        'answer_id' => $answerId,
                    ]);
                }
            } else {
                $assessment->answers()->create([
                    'answer_id' => $id,
                ]);
            }
        }

        $payload->put('submittedAnswers', $assessment->answers);

        return $next($payload);
    }
}
