<?php

namespace Concept7\LaravelQuestionnaire\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Concept7\LaravelQuestionnaire\Models\Answer>
 */
class AnswerFactory extends Factory
{
    public function modelName(): string
    {
        return config('questionnaire.models.answer');
    }

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'text' => fake()->sentence(),
            'score' => fake()->numberBetween(1, 10),
            'order' => fake()->numberBetween(1, 10),
        ];
    }
}
