<?php

namespace Concept7\LaravelQuestionnaire\Traits;

use Concept7\LaravelQuestionnaire\Models\Concerns\HasAssessments;
use Illuminate\Database\Eloquent\Relations\MorphMany;

/**
 * Trait AssessmentableTrait
 *
 * @mixin \Illuminate\Database\Eloquent\Model
 */
trait AssessmentableTrait
{
    use HasAssessments;

    public function assessments(): MorphMany
    {
        return $this->morphMany($this->getAssessmentClass(), 'assessmentable');
    }
}
