<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Concept7\LaravelQuestionnaire\Database\Factories\AnswerFactory;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasInterpretations;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Scale extends Model
{
    /** @use HasFactory<AnswerFactory> */
    use HasFactory;

    use HasInterpretations;

    protected $fillable = [
        'name',
        'description',
    ];

    public function interpretations(): HasMany
    {
        return $this->hasMany($this->getInterpretationClass());
    }
}
