<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Concept7\LaravelQuestionnaire\Enums\CalculationTypeEnum;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasAnswers;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasAssessments;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasQuestions;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Str;

class Questionnaire extends Model
{
    use HasAnswers;

    use HasAssessments;
    /** @use HasFactory<\Database\Factories\QuestionnaireFactory> */
    use HasFactory;
    use HasQuestions;

    protected $fillable = ['title', 'slug', 'calculation_type'];

    protected $casts = ['calculation_type' => CalculationTypeEnum::class];

    protected static function booted(): void
    {
        static::creating(function ($questionnaire) {
            if (empty($questionnaire->slug)) {
                $questionnaire->slug = Str::slug($questionnaire->title);
            }
        });
    }

    protected function slug(): Attribute
    {
        return Attribute::make(get: fn (?string $value) => $value);
    }

    public function assessments(): HasMany
    {
        return $this->hasMany($this->getAssessmentClass());
    }

    public function answerModel(): string
    {
        return $this->getAnswerClass();
    }

    /**
     * Get all questions associated with this questionnaire.
     */
    public function questions(): HasMany
    {
        return $this->hasMany($this->getQuestionClass());
    }
}
