<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Concept7\LaravelQuestionnaire\Database\Factories\QuestionFactory;
use Concept7\LaravelQuestionnaire\Enums\InputTypeEnum;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasAnswers;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasCategories;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasQuestionnaires;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;

class Question extends Model implements Sortable
{
    use HasAnswers;

    use HasCategories;
    /** @use HasFactory<QuestionFactory> */
    use HasFactory;
    use HasQuestionnaires;
    use SortableTrait;

    protected $casts = [
        'type' => InputTypeEnum::class,
    ];

    public $sortable = [
        'order_column_name' => 'order',
        'sort_when_creating' => true,
    ];

    protected $fillable = [
        'text',
        'order',
        'category_id',
        'questionnaire_id',
        'type',
        'weight',
    ];

    public function questionnaire(): BelongsTo
    {
        return $this->belongsTo($this->getQuestionnaireClass());
    }

    public function category(): BelongsTo
    {
        return $this->BelongsTo($this->getCategoryClass());
    }

    public function answers(): HasMany
    {
        return $this->hasMany($this->getAnswerClass());
    }

    protected function sliderMin(): Attribute
    {
        return Attribute::make(
            get: fn () => $this->category->interpretation?->min_score ?? 0,
        );
    }

    protected function sliderMax(): Attribute
    {
        return Attribute::make(
            get: fn () => $this->category->interpretation?->max_score ?? 10,
        );
    }

    /**
     * Gets the slider's LEFT label from the parent scale.
     */
    protected function sliderLabelMin(): Attribute
    {
        return Attribute::make(
            get: fn () => $this->interpretation?->scale?->name ?? 'Min',
        );
    }

    /**
     * Gets the slider's RIGHT label from the parent scale.
     */
    protected function sliderLabelMax(): Attribute
    {
        return Attribute::make(
            get: fn () => $this->interpretation?->scale?->name ?? 'Max',
        );
    }
}
