<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Concept7\LaravelQuestionnaire\Database\Factories\AnswerFactory;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasCategories;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasScales;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Interpretation extends Model
{
    use HasCategories;

    /** @use HasFactory<AnswerFactory> */
    use HasFactory;
    use HasScales;

    protected $fillable = [
        'category_id',
        'scale_id',
        'min_score',
        'max_score',
    ];

    public function scale(): BelongsTo
    {
        return $this->BelongsTo($this->getScaleClass());
    }

    public function category(): BelongsTo
    {
        return $this->BelongsTo($this->getCategoryClass());
    }
}
