<?php

namespace Concept7\LaravelQuestionnaire\Models\Concerns;

use Concept7\LaravelQuestionnaire\Models\AssessmentResult;

trait HasAssessmentResults
{
    /**
     * Retrieve the FQCN of the class to use for AssessmentResult models.
     *
     * @return class-string<AssessmentResult>
     */
    public function getAssessmentResultClass(): string
    {
        return config('questionnaire.models.assessment_result', AssessmentResult::class);
    }
}
