<?php

namespace Concept7\LaravelQuestionnaire\Models\Concerns;

use Concept7\LaravelQuestionnaire\Models\AssessmentAnswer;

trait HasAssessmentAnswers
{
    /**
     * Retrieve the FQCN of the class to use for AssessmentAnswer models.
     *
     * @return class-string<AssessmentAnswer>
     */
    public function getAssessmentAnswerClass(): string
    {
        return config('questionnaire.models.assessment_answer', AssessmentAnswer::class);
    }
}
