<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Concept7\LaravelQuestionnaire\Database\Factories\CategoryFactory;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasInterpretations;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasQuestions;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasScales;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Category extends Model
{
    /** @use HasFactory<CategoryFactory> */
    use HasFactory;

    use HasInterpretations;
    use HasQuestions;
    use HasScales;

    protected $fillable = [
        'name',
        'description',
    ];

    public function questions(): HasMany
    {
        return $this->hasMany($this->getQuestionClass());
    }

    public function scale(): BelongsTo
    {
        return $this->belongsTo($this->getScaleClass());
    }

    public function interpretation(): HasMany
    {
        return $this->hasMany($this->getInterpretationClass());
    }
}
