<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Concept7\LaravelQuestionnaire\Database\Factories\AnswerFactory;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasAssessments;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasCategories;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasScales;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AssessmentResult extends Model
{
    use HasAssessments;

    use HasCategories;
    /** @use HasFactory<AnswerFactory> */
    use HasFactory;
    use HasScales;

    protected $fillable = [
        'assessment_id',
        'category_id',
        'total_score',
        'scale_id',
        'created_at',
        'updated_at',
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo($this->getCategoryClass());
    }

    public function assessment(): BelongsTo
    {
        return $this->belongsTo($this->getAssessmentClass());
    }

    public function scale(): BelongsTo
    {
        return $this->belongsTo($this->getScaleClass());
    }

    protected function formattedPercentage(): Attribute
    {
        return Attribute::make(
            get: function () {
                return match ($this->assessment->questionnaire->calculation_type) {
                    default => $this->totalScore.'%',
                };
            }
        );
    }

    public function calculatePercentage($totalScore)
    {
        return round(($totalScore / $this->scale()->max_score) * 100).'%';
    }
}
