<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Concept7\LaravelQuestionnaire\Models\Concerns\HasAnswers;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasAssessments;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AssessmentAnswer extends Model
{
    use HasAnswers;

    use HasAnswers;
    use HasAssessments;
    /** @use HasFactory<AnswerFactory> */
    use HasFactory;

    protected $fillable = [
        'assessment_id',
        'answer_id',
    ];

    public function answer(): BelongsTo
    {

        return $this->belongsTo($this->getAnswerClass());
    }

    public function assessment(): BelongsTo
    {
        return $this->belongsTo($this->getAssessmentClass());
    }
}
