<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Concept7\LaravelQuestionnaire\Models\Concerns\HasAssessmentAnswers;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasAssessmentResults;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasInterpretations;
use Concept7\LaravelQuestionnaire\Models\Concerns\HasQuestionnaires;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class Assessment extends Model
{
    use HasAssessmentAnswers;

    use HasAssessmentResults;
    /** @use HasFactory<\Concept7\LaravelQuestionnaire\Database\Factories\AssessmentFactory> */
    use HasFactory;
    use HasInterpretations;
    use HasQuestionnaires;

    protected $fillable = [
        'questionnaire_id',
        'completed_at',

        'assessmentable_id',
        'assessmentable_type',
    ];

    /**
     * @return MorphTo<Model,Assessment>
     */
    public function assessmentable(): MorphTo
    {
        return $this->morphTo();
    }

    public function interpretationModel(): string
    {
        return $this->getInterpretationClass();
    }

    /**
     * @return BelongsTo<Model,Assessment>
     */
    public function questionnaire(): BelongsTo
    {
        return $this->belongsTo($this->getQuestionnaireClass());
    }

    /**
     * @return HasMany<Model,Assessment>
     */
    public function answers(): HasMany
    {
        return $this->hasMany($this->getAssessmentAnswerClass());
    }

    /**
     * @return HasMany<Model,Assessment>
     */
    public function results(): HasMany
    {
        return $this->hasMany($this->getAssessmentResultClass());
    }
}
