<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;

class Answer extends Model implements Sortable
{
    /** @use HasFactory<AnswerFactory> */
    use HasFactory;

    use SortableTrait;

    public $sortable = [
        'order_column_name' => 'order',
        'sort_when_creating' => true,
    ];

    protected $fillable = [
        'text',
        'score',
        'order',
        'question_id',
    ];

    /**
     * Get the class name for the Question model.
     *
     * * @return class-string<Question>
     */
    public function getQuestionClass(): string
    {
        return config('questionnaire.models.question', Question::class);
    }

    /**
     * @return BelongsTo<Question, $this>
     */
    public function question(): BelongsTo
    {
        return $this->belongsTo($this->getQuestionClass());
    }
}
