<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments;

use Closure;
use Illuminate\Support\Collection;

class CreateAssessment
{
    /**
     * @param  Collection<array-key,mixed>  $payload
     * @param  Closure(): void  $next
     * @return void
     */
    public function handle(Collection $payload, Closure $next)
    {
        if (! $payload->has('questionnaire')) {
            throw new \Exception('Questionnaire not found');
        }

        $questionnaire = $payload->get('questionnaire');

        $attributes = [
            'questionnaire_id' => $questionnaire->getKey(),
            'completed_at' => now(),
        ];

        if ($payload->has('participant')) {
            $participant = $payload->get('participant');
            $assessment = $participant
                ->assessments()
                ->create($attributes);
        } else {
            $assessment = $questionnaire
                ->assessments()
                ->create($attributes);
        }

        $payload->put('assessment', $assessment);

        return $next($payload);
    }
}
