@props(['question', 'fieldName', 'oldValue'])

@foreach($question->answers as $answer)
    @php
        $fieldId = 'answer_' . $answer->getKey();
        $isChecked = is_array($oldValue) && in_array($answer->getKey(), $oldValue);
    @endphp
    <div class="relative flex items-center">
        <x-laravel-questionnaire::checkbox
            id="{{ $fieldId }}"
            name="{{ $fieldName }}[]" {{-- Note the array brackets --}}
            value="{{ $answer->getKey() }}"
            :checked="$isChecked"
        ></x-laravel-questionnaire::checkbox>
        <label for="{{ $fieldId }}" class="ml-2 text-sm font-medium text-gray-900">
            {{ $answer->text }}
        </label>
    </div>
@endforeach


