<?php

namespace Concept7\Deployer\Recipe\Laravel;

use Concept7\Deployer\Traits\CheckGitStatus;
use Concept7\Deployer\Traits\Crontab;
use Concept7\Deployer\Traits\ScheduleMonitor;
use Concept7\Deployer\Traits\SetCodeStrategy;
use Concept7\Deployer\Traits\StatamicStaticWarm;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\UploadVendors;
use Concept7\Deployer\Traits\WorkersRestart;

class LaravelStatamic extends Laravel
{
    use CheckGitStatus;
    use Crontab;
    use ScheduleMonitor;
    use SetCodeStrategy;
    use StatamicStaticWarm;
    use UploadAssets;
    use UploadVendors;
    use WorkersRestart;

    /** @var array<string> */
    protected array $deploySteps = [
        'deploy:prepare',
        'upload:vendors',
        'upload:assets',
        'artisan:storage:link',
        'artisan:migrate',
        'artisan:optimize:clear',
        'artisan:optimize',
        'artisan:view:cache',
        'artisan:event:cache',
        'statamic:stache:clear',
        'statamic:stache:warm',
        'statamic:static:clear',
        'statamic:glide:clear',
        'deploy:publish',
        'statamic:search:update',
        'php:restart',
        'opcache:clear',
        'workers:restart',
        'statamic:static:warm:queue',
        'crontabs:update',
        'artisan:schedule-monitor:sync',
    ];

    /** @var array<string> */
    protected array $additionalDeployerRecipes = [
        'recipe/laravel.php',
        'recipe/statamic.php',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadVendors();
        $this->uploadAssets();
        $this->checkGitStatus();
        $this->setCodeStrategy();
        $this->addLaravelSchedulerToCrontab();
        $this->workersRestart();
        $this->scheduleMonitorSync();
        $this->loadStatamicStaticWarmTask();
        $this->addLaravelSchedulerToCrontab();
    }
}
