<?php

namespace Concept7\Deployer\Traits;

use Concept7\Deployer\Enum\HostingType;
use Exception;

trait Environments
{
    /** @var array<array<string>> */
    protected array $environments = [];

    /** @param  array<array<string>>  $environments */
    public function setEnvironments(array $environments): self
    {
        $this->environments = $environments;

        return $this;
    }

    public function setEnvironment(
        string $environment,
        string $host,
        string $deploy_path,
        string $hostname,
        string $remote_user,
        int $port = 22,
        string $branch = 'main',
        HostingType $hosting_type = HostingType::Forge,
        ?string $worker_names = null
    ): self {
        if (isset($this->environments[$environment])) {
            throw new Exception('Environment: ['.$environment.'] already defined');
        }

        $this->environments[$environment] = [
            'host' => $host,
            'hostname' => $hostname,
            'remote_user' => $remote_user,
            'port' => $port,
            'branch' => $branch,
            'deploy_path' => $deploy_path,
            'hosting_type' => $hosting_type,
            'worker_names' => $worker_names,
        ];

        return $this;
    }

    public function setStaging(
        string $host,
        string $deploy_path,
        string $hostname = 'staging.concept7.dev',
        string $remote_user = 'forge',
        int $port = 22,
        string $branch = 'develop',
        HostingType $hosting_type = HostingType::Forge,
        ?string $worker_names = null
    ): self {
        return $this->setEnvironment(
            environment: 'staging',
            host: $host,
            hostname: $hostname,
            remote_user: $remote_user,
            port: $port,
            branch: $branch,
            deploy_path: $deploy_path,
            hosting_type: $hosting_type,
            worker_names: $worker_names,
        );
    }

    public function setAcceptance(
        string $host,
        string $deploy_path,
        string $hostname = 'acceptance.concept7.dev',
        string $remote_user = 'forge',
        int $port = 22,
        string $branch = 'main',
        HostingType $hosting_type = HostingType::Forge,
        ?string $worker_names = null
    ): self {
        return $this->setEnvironment(
            environment: 'acceptance',
            host: $host,
            hostname: $hostname,
            remote_user: $remote_user,
            port: $port,
            branch: $branch,
            deploy_path: $deploy_path,
            hosting_type: $hosting_type,
            worker_names: $worker_names,
        );
    }

    public function setProduction(
        string $host,
        string $deploy_path,
        string $hostname,
        string $remote_user,
        int $port = 22,
        string $branch = 'main',
        HostingType $hosting_type = HostingType::LinQhost,
        ?string $worker_names = null
    ): self {
        return $this->setEnvironment(
            environment: 'production',
            host: $host,
            hostname: $hostname,
            remote_user: $remote_user,
            port: $port,
            branch: $branch,
            deploy_path: $deploy_path,
            hosting_type: $hosting_type,
            worker_names: $worker_names,
        );
    }
}
