<?php

namespace Concept7\Deployer\Recipe\Laravel\Multitenancy;

use Concept7\Deployer\Recipe\Laravel\Laravel;
use Concept7\Deployer\Traits\CheckGitStatus;
use Concept7\Deployer\Traits\MultitenancyArtisan;
use Concept7\Deployer\Traits\SetCodeStrategy;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\UploadVendors;
use Concept7\Deployer\Traits\WorkersRestart;

class Statamic extends Laravel
{
    use CheckGitStatus;
    use MultitenancyArtisan;
    use SetCodeStrategy;
    use UploadAssets;
    use UploadVendors;
    use WorkersRestart;

    /** @var array<string> */
    protected array $deploySteps = [
        'upload:vendors',
        'rsync',
        'artisan:storage:link',
        'artisan:optimize:clear',
        'artisan:config:cache',
        'artisan:event:cache',
        'artisan:route:cache',
        'artisan:view:cache',
        'statamic:stache:warm',
        'deploy:publish',
        'php-fpm-reload',
        'workers:restart',
    ];

    /** @var array<string> */
    protected array $additionalDeployerRecipes = [
        'recipe/statamic.php',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadVendors();
        $this->uploadAssets();
        $this->checkGitStatus();
        $this->setCodeStrategy();
        $this->registerArtisanTasks();
        $this->workersRestart();
    }
}
