<?php

namespace Concept7\Deployer\Recipe\Laravel\Multitenancy;

use Concept7\Deployer\Recipe\Laravel\Laravel as LaravelLaravel;
use Concept7\Deployer\Traits\MultitenancyArtisan;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\UploadVendors;
use Concept7\Deployer\Traits\WorkersRestart;

class Laravel extends LaravelLaravel
{
    use MultitenancyArtisan;
    use UploadAssets;
    use UploadVendors;
    use WorkersRestart;

    /** @var array<string> */
    protected array $deploySteps = [
        'upload:vendors',
        'upload:assets',
        'artisan:storage:link',
        'artisan:migrate',
        'deploy:publish',
        'php:restart',
        'opcache:clear',
        'artisan:config:cache',
        'artisan:event:cache',
        'artisan:route:cache',
        'artisan:view:cache',
        'workers:restart',
    ];

    /** @var array<string> */
    protected array $additionalDeployerRecipes = [
        'recipe/laravel.php',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadVendors();
        $this->uploadAssets();
        $this->registerArtisanTasks();
        $this->workersRestart();
    }
}
