<?php

namespace Concept7\Deployer\Traits;

use Composer\InstalledVersions;

trait FilterTasks
{
    /**
     * @param  array<string>  $deploySteps
     * @return array<string>
     */
    private function filterBasedOnInstalledComposerPackages(array $deploySteps = []): array
    {
        $filterOn = [
            'spatie/laravel-schedule-monitor' => 'artisan:schedule-monitor:sync',
            'darkaonline/l5-swagger' => 'artisan:l5-swagger:generate',
            'timokoerber/laravel-one-time-operations' => 'artisan:operations:process',
            'wpackagist-plugin/redis-cache' => 'wp:redis-enable',
            'filament/filament' => 'artisan:filament:optimize',
        ];

        // fix because: PHPStan was confused because of the usage of $this in a callback function inside the array_filter function.
        $self = $this;
        foreach ($filterOn as $package => $taskName) {
            $deploySteps = array_filter(
                $deploySteps,
                static fn ($step) => $step !== $taskName || ($step === $taskName && $self->isPackageInstalled($package))
            );
        }

        return $deploySteps;
    }

    private function isPackageInstalled(string $package): bool
    {
        $installedComposerPackages = InstalledVersions::getInstalledPackages();

        return in_array($package, $installedComposerPackages);
    }
}
