<?php

namespace Concept7\Deployer\Traits;

use function Deployer\task;
use function Deployer\testLocally;
use function Deployer\upload;

trait UploadAssets
{
    private function uploadAssets(?string $wpAssetsDir = null): void
    {
        task('upload:assets', static function () use ($wpAssetsDir) {
            $config = [
                'flags' => '-az',
                'progress_bar' => false,
                'display_stats' => false,
            ];

            if (testLocally('[ -d public/build ]')) {
                upload('public/build/', '{{release_path}}/public/build', $config);
            }

            if (testLocally('[ -d public/css ]')) {
                upload('public/css/', '{{release_path}}/public/css', $config);
            }

            if (testLocally('[ -d public/js ]')) {
                upload('public/js/', '{{release_path}}/public/js', $config);
            }

            if (! is_null($wpAssetsDir) && testLocally('[ -d '.$wpAssetsDir.' ]')) {
                upload(
                    $wpAssetsDir.'/',
                    '{{release_path}}/'.$wpAssetsDir,
                    $config
                );
            }
        });
    }
}
