<?php

namespace Concept7\Deployer;

use Concept7\Deployer\Enum\Recipe;
use Concept7\Deployer\Recipe\Base;
use Concept7\Deployer\Recipe\Laravel\Laravel;
use Concept7\Deployer\Recipe\Laravel\LaravelStatamic;
use Concept7\Deployer\Recipe\Laravel\Multitenancy\LaravelStatamic as MultitenancyLaravelStatamic;
use Concept7\Deployer\Recipe\Laravel\Statamic;
use Concept7\Deployer\Recipe\Wordpress\Wordpress;
use Concept7\Deployer\Traits\Environments;
use Concept7\Deployer\Traits\PhpVersion;

class Loader
{
    use Environments;
    use PhpVersion;

    private Recipe $recipe;

    private string $name;

    private string $repository;

    public function setProject(string $name, string $repository): self
    {
        return $this->project($name, $repository);
    }

    public function project(string $name, string $repository): self
    {
        $this->name = $name;
        $this->repository = $repository;

        return $this;
    }

    public function setRecipe(Recipe $recipe): self
    {
        $this->recipe = $recipe;

        return $this;
    }

    public function recipe(Base $recipe): Base
    {
        $allowedRecipes = [
            Wordpress::class,
            Laravel::class,
            Statamic::class,
            LaravelStatamic::class,
        ];

        if (! in_array($recipe::class, $allowedRecipes)) {
            throw new \Exception('Recipe not found');
        }

        return $recipe->setRepository($this->repository)
            ->setApplication($this->name);
    }

    public function execute(): void
    {
        $recipe = match ($this->recipe) {
            Recipe::Laravel => Laravel::class,
            Recipe::LaravelStatamic => LaravelStatamic::class,
            Recipe::Statamic => Statamic::class,
            Recipe::Wordpress => Wordpress::class,
            Recipe::MultitenancyLaravelStatamic => MultitenancyLaravelStatamic::class,
            default => throw new \Exception('Recipe ['.$this->recipe->value.'] not found')
        };

        /** @var Base */
        $class = new $recipe();

        $class
            ->setRepository($this->repository)
            ->setApplication($this->name)
            ->setPhpVersion($this->phpVersion)
            ->setEnvironments($this->environments)
            ->execute();
    }
}
