<?php

namespace Concept7\Deployer\Traits;

use Concept7\Deployer\Enum\HostingType;
use Deployer\Task\Context;
use Deployer\Utility\Httpie;

use function Deployer\artisan;
use function Deployer\run;
use function Deployer\runLocally;
use function Deployer\task;
use function Deployer\warning;
use function Deployer\writeln;

trait HorizonRestart
{
    private function horizonRestart(): void
    {
        task('forge:horizon:restart', static function () {
            writeln('Restarting in Forge');
            artisan('horizon:terminate');
        })
            ->select('hostingType='.HostingType::Forge->value);

        task('linqhost:horizon:restart', static function () {
            writeln('Restarting in LinQhost');
            $host = Context::get()->getHost();
            $name = $host->get('queue_worker_name');
            if (! $name) {
                warning('Worker name missing');

                return;
            }

            $host = 'https://'.$host->get('hostname').'/lh_supervisor';
            run(sprintf('curl -sLO %s/control/restart/localhost/%s ', $host, $name));
        })->select('hostingType='.HostingType::LinQhost->value);

        task('combell:horizon:restart', static function () {
            writeln('Restarting in Combell');
            $host = Context::get()->getHost();
            $name = $host->get('queue_worker_name');
            if (! $name) {
                warning('Worker name missing');

                return;
            }

            $options = $host->connectionOptionsString();
            runLocally(sprintf('ssh -t %s %s platform worker restart -n %s', $options, $host->connectionString(), $name));
        })->select('hostingType='.HostingType::Combell->value);

        task('horizon:restart', ['forge:horizon:restart', 'linqhost:horizon:restart', 'combell:horizon:restart']);
    }

    private function supervisordControlAction(string $host, string $name, string $action = 'stop'): bool
    {
        $stopResponseInfo = [];
        Httpie::post($host.'/control/'.$action.'/localhost/'.$name)->send($stopResponseInfo);

        return $stopResponseInfo['http_code'] === 200;
    }
}
