<?php

namespace Concept7\Deployer\Recipe\Laravel;

use Concept7\Deployer\Recipe\Base;
use Concept7\Deployer\Traits\HorizonRestart;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\UploadVendors;
use Concept7\Deployer\Traits\WebsocketsRestart;

class Laravel extends Base
{
    use HorizonRestart;
    use UploadAssets;
    use UploadVendors;
    use WebsocketsRestart;

    /** @var array<string> */
    protected array $deploySteps = [
        'deploy:prepare',
        'upload:vendors',
        'upload:assets',
        'artisan:storage:link',
        'artisan:migrate',
        'artisan:optimize:clear',
        'artisan:optimize',
        'artisan:view:cache',
        'artisan:event:cache',
        'deploy:publish',
        'php:restart',
        'cachetool:clear:opcache',
        'horizon:restart',
        'websockets:restart',
    ];

    /** @var array<string> */
    protected array $additionalDeployerRecipes = [
        'recipe/laravel.php',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadVendors();
        $this->uploadAssets();
        $this->horizonRestart();
        $this->websocketsRestart();
    }
}
