<?php

namespace Concept7\Deployer\Recipe\Laravel;

use Concept7\Deployer\Recipe\Base;
use Concept7\Deployer\Traits\Crontab;
use Concept7\Deployer\Traits\Deployer;
use Concept7\Deployer\Traits\Filament;
use Concept7\Deployer\Traits\LaravelOneTimeOperations;
use Concept7\Deployer\Traits\ManageForgeSite;
use Concept7\Deployer\Traits\ScheduleMonitor;
use Concept7\Deployer\Traits\Swagger;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\UploadVendors;
use Concept7\Deployer\Traits\WorkersRestart;

class Laravel extends Base
{
    use Crontab;
    use Deployer;
    use Filament;
    use LaravelOneTimeOperations;
    use ManageForgeSite;
    use ScheduleMonitor;
    use Swagger;
    use UploadAssets;
    use UploadVendors;
    use WorkersRestart;

    /** @var array<string> */
    protected array $deploySteps = [
        'c7-deployer:info',
        'deploy:prepare',
        'upload:vendors',
        'upload:assets',
        'artisan:storage:link',
        'artisan:migrate',
        'artisan:operations:process',
        'artisan:optimize:clear',
        'artisan:optimize',
        'artisan:filament:optimize',
        'artisan:view:cache',
        'artisan:event:cache',
        'deploy:publish',
        'php:restart',
        'opcache:clear',
        'workers:restart',
        'crontabs:update',
        'artisan:schedule-monitor:sync',
        'artisan:l5-swagger:generate',
    ];

    /** @var array<string> */
    protected array $defaultSharedFiles = [
        '.env',
    ];

    /** @var array<string> */
    protected array $defaultSharedDirectories = [
        'storage/app',
        'storage/logs',
    ];

    /** @var array<string> */
    protected array $defaultWritableDirectories = [
        'bootstrap/cache',
        'storage',
        'storage/app',
        'storage/app/public',
        'storage/framework',
        'storage/framework/cache',
        'storage/framework/cache/data',
        'storage/framework/sessions',
        'storage/framework/views',
        'storage/logs',
    ];

    /** @var array<string> */
    protected array $additionalDeployerRecipes = [
        'recipe/laravel.php',
        'contrib/crontab.php',
    ];

    public function __construct()
    {
        parent::__construct();

        $this->setWebPath('./public');
    }

    public function loadExtraDeployerSteps(): void
    {
        $this->info();
        $this->createSite();
        $this->deleteSite();
        $this->uploadVendors();
        $this->uploadAssets();
        $this->addLaravelSchedulerToCrontab();
        $this->workersRestart();
        $this->scheduleMonitorSync();
        $this->generateSwaggerDocs();
        $this->operationsProcess();
        $this->filamentOptimize();
    }
}
