<?php

namespace Concept7\Deployer\Traits;

use Concept7\Deployer\Connections\Forge;
use Illuminate\Support\Collection;

use function Deployer\get;
use function Deployer\task;

trait ManageForgeSite
{
    public function createSite(): void
    {
        $self = $this;
        task('forge:create:site', static function () use ($self) {
            $variables = $self->getVariables();

            (new Forge(apiKey: $variables->get('apiKey'), serverId: (int) $variables->get('serverId')))
                ->createSite(
                    siteUrl: $variables->get('siteUrl'),
                    phpVersion: $variables->get('phpVersion')
                );
        });
    }

    public function deleteSite(): void
    {
        $self = $this;
        task('forge:delete:site', static function () use ($self) {
            $variables = $self->getVariables();
            (new Forge(apiKey: $variables->get('apiKey'), serverId: (int) $variables->get('serverId')))
                ->deleteSite(
                    siteUrl: $variables->get('siteUrl'),
                );
        });
    }

    /**
     * @return Collection<string, string>
     */
    private function getVariables(): Collection
    {
        $forgeVariables = collect($_SERVER)
            ->filter(static fn ($value, $key) => str_starts_with($key, 'DEPLOYER__'));

        /** @var string */
        $apiKey = $forgeVariables->get('DEPLOYER__FORGE_API_KEY');
        /** @var int */
        $serverId = $forgeVariables->get('DEPLOYER__FORGE_STAGING_SERVER_ID');
        /** @var string */
        $siteUrl = $forgeVariables->get('DEPLOYER__SITE_URL');
        /** @var string */
        $phpVersion = str_replace(['.', '/usr/bin/'], '', get('bin/php'));

        $variables = [$apiKey, $serverId, $siteUrl];

        if (count(array_filter($variables, static fn ($val) => $val !== 0 && ($val !== '' && $val !== '0'))) < count($variables)) {
            throw new \Exception('One of the following variables is empty: FORGE_API_KEY, FORGE_STAGING_SERVER_ID, SITE_URL');
        }

        return collect(['apiKey' => $apiKey, 'serverId' => $serverId, 'siteUrl' => $siteUrl, 'phpVersion' => $phpVersion]);
    }
}
