<?php

namespace Concept7\Deployer\Recipe\StaticSite;

use Concept7\Deployer\Recipe\Base;
use Concept7\Deployer\Traits\UploadPublic;

class StaticSite extends Base
{
    use UploadPublic;

    protected array $deploySteps = [
        'deploy:prepare',
        'upload:public',
        'deploy:publish',
        'php:restart',
        'opcache:clear',
    ];

    public function __construct()
    {
        parent::__construct();

        $this->setWebPath('./public');
    }

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadPublic();
    }
}
