<?php

namespace Concept7\Deployer\Traits;

use function Deployer\artisan;
use function Deployer\invoke;
use function Deployer\run;
use function Deployer\task;
use function Deployer\warning;

trait StatamicStaticWarm
{
    public function loadStatamicStaticWarmTask(): void
    {
        task('tmp-statamic:static:warm:queue', artisan('statamic:static:warm --queue', ['showOutput']));

        task('statamic:static:warm:queue', static function () {

            $staticCachingStrategy = run('set -a; source {{release_or_current_path}}/.env; set +a; echo $STATAMIC_STATIC_CACHING_STRATEGY');
            if (str_contains($staticCachingStrategy, 'full') || str_contains($staticCachingStrategy, 'half')) {
                invoke('tmp-statamic:static:warm:queue');
            } else {
                warning('Static cache seems to be disabled');
            }
        });
    }
}
