<?php

namespace Concept7\Deployer\Traits\Loader;

trait PhpVersion
{
    protected float $defaultPhpVersion = 8.0;

    protected ?float $phpVersion;

    protected bool $phpVersionManuallySet = false;

    public function phpVersion(float $version): self
    {
        $this->phpVersion = $version;

        return $this;
    }

    public function setPhpVersion(float $version): self
    {
        $this->phpVersionManuallySet = true;

        return $this->phpVersion($version);
    }

    public function guessAndSetPhpVersion(): self
    {
        $valetRcPhpVersion = $this->readPhpVersionFromValetRc();

        if (is_float($valetRcPhpVersion)) {
            return $this->phpVersion($valetRcPhpVersion);
        }

        return $this->phpVersion($this->defaultPhpVersion);
    }

    public function readPhpVersionFromValetRc(): ?float
    {
        $path = dirname(__FILE__, 7).'/.valetrc';

        if (! file_exists($path)) {
            return null;
        }

        $contents = file_get_contents($path);

        if (preg_match('/^php=php@([0-9]+\.[0-9]+)/m', $contents, $matches)) {
            return (float) $matches[1];
        }

        return null;
    }
}
